/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Mtx.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    rcX Mutex function prototypes and definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2011-05-20  ported from rcX V2

**************************************************************************************/

#ifndef __AP_MTX_H
#define __AP_MTX_H

#ifdef __cplusplus
  extern "C" {
#endif


  /***************************************************************************
  * Size of the handle that needs to be allocated when creating a mutex
  ***************************************************************************/
  #define RX_MUTEX_SIZE (64)

  /*************************************************************
  * Function Prototypes
  *************************************************************/
  RX_RESULT FAR rX_MtxCreateMutex     (const STRING FAR*      pszIdn,
                                       RX_HANDLE              hMutex,
                                       UINT                   uMaxProc);

  RX_RESULT FAR rX_MtxIdentifyMutex   (const STRING FAR*      pszIdn,
                                       UINT                   uInst,
                                       RX_HANDLE FAR*         phMutex);

  RX_RESULT FAR rX_MtxDeleteMutex     (RX_HANDLE              hMutex);

  RX_RESULT FAR rX_MtxLockMutex       (RX_HANDLE              hMutex,
                                       UINT                   uiTiemout);

  RX_RESULT FAR rX_MtxUnlockMutex     (RX_HANDLE              hMutex);


#ifdef __cplusplus
}
#endif

#endif /* __AP_MTX_H */
